module memblkstd(
  input clk,
  input rst,
  output reg stall,
  input [15:0] random,  
  input [38:0] rdaddr0,
  input [39:0] rdphydata0,
  output reg [8*66+4:0] rddata,
  input  rden_in,
  output reg [3:0][36:0] rdaddr,
  output reg  rd_pltpage,
  output reg [39:0] rdphydata,
  output reg  rden_out,
  input [38:0] wraddr0,
  input [8*66+4:0] wrdata,
  input  wren_in,
  output reg [3:0][36:0] wraddr,
  output reg  wren_out,
  input [1:0] tileX,
  input [1:0] tileY,
  input [6:0] PHY,
  input [2:0] memsz,
);
  

  reg [82:0][1:0] wsz0_reg;
  reg [82:0][32:0] waddr0_reg;
  reg [3:0][33:0] waddr0_xtra;
  reg [3:0][33:0] waddr0_xtra_reg;
  reg [32:0] waddr0_rexx;
  reg [32:0] waddr0_rexx2;
  reg [82:0][66*8-1:0] wrdata_reg;
  reg [82:0] wren_in_reg;
  reg [82:0][32:0] rdaddr0_reg;
  reg [82:0][39:0] rdphydata0_reg;
  reg [32:0] rdaddr0_rexx;
  reg [32:0] rdaddr0_rexx2;
  reg [3:0][33:0] rdaddr0_xtra;
  reg [3:0][33:0] rdaddr0_xtra_reg;
  reg [82:0] rden_in_reg;
  reg [82:0][32:0] rdaddr_reg;
  reg [82:0][3:0] rdxdata_reg;
 
  import "DPI-C" function int rdram(input int addr, input int piece, input int tx, input int ty);
  import "DPI-C" function int rdramx(input int addr, input int tx, input int ty);
  import "DPI-C" function int wrblockwr(input int addr, input [8*66-1:0] piece, input int tx, input int ty);
  import "DPI-C" function int wrblockx(input int addr, input int piece,input int tx, input int ty); 
  import "DPI-C" function int sendaddr(input int addr);
  import "DPI-C" function int sendaddrtlb(input int addr);
  import "DPI-C" function int sendtcore(input int addr);
  integer rdport;
  integer regcnt;
  integer tlbptr;

  wire rdnshare;
  wire [4*66-1:0] tlbdata;
  wire [4*66-1:0] tlbdataw;
  reg [4*66-1:0] tlbdata_reg;
  reg [4*66-1:0] tlbdataw_reg;
  reg [5:0] stcnt;
  
  `define rng_X [0]
  `define rng_Y [0]
  
  assign rdnshare=(random&16'h1ff)==16'd5;
  generate
    genvar k;
    for(k=0;k<17;k=k+1) begin
        /* verilator lint_off WIDTHTRUNC */
        assign tlbdata[k*32+:32]=rdram(1<<30+rdaddr0_reg[44][27:6],k,tileX,tileY);
        assign tlbdataw[k*32+:32]=tlbdata[k*32+:32]<<4*66*rdaddr0_reg[44][28];
        /* verilator lint_on WIDTHTRUNC */

        assign rddata[k*32+:32]={rdramx(rdaddr0_reg[access][30:0],tileX,tileY)[3:0],rdram(rdaddr0_reg[access][30:0],k,tileX,tileY)};
 
    end
  endgenerate
        assign othercore=rdaddr0_reg[access][36:31]!={tileX[4:2],tileY[4:2]};
        assign access=|othercore_r[82:47]? 82: 47;
        
        assign {rd_pltpage,rdaddr[0]}={rdaddr0_xtra[0]};
        assign rdaddr[1]={rdaddr0_xtra[1]};
        assign rdaddr[2]={rdaddr0_xtra[2]};
        assign rdaddr[3]={rdaddr0_xtra[3]};
        assign wraddr[0]={waddr0_xtra[0]};
        assign wraddr[1]={waddr0_xtra[1]};
        assign wraddr[2]={waddr0_xtra[2]};
        assign wraddr[3]={waddr0_xtra[3]};
        assign rden_out=rden_in_reg[access];  
        assign rdphydata=rdphydata0_reg[access];
    stall=stcnt!=0 || !|wren_in_reg[256+{PHY[1:0],tileX[0],tileY[0],4'b0}];
    always @* begin 
    sendaddr(rdaddr0_reg[1][30:0],tileX, tileY);
    sendtcore(rdaddr0_reg[1][36:1]);
    sendaddrtlb(1<<30+rdaddr0_reg[1][25:6],tileX,tileY);
    for(rdport=0;rdport<16;rdport=rdport+1) begin
       if (rdaddr0_reg[access]==rdaddr0_reg[48+rdport] && rden_in_reg[48+rdport] && rden_in_reg[access]) stall=1;
    end
  end
  always @(posedge clk) if (!stall) begin
    //     wrdata_reg[0]<=wrdata; !|wren_in_reg[8]
    `ifdef nmos5nm 
    if (rst) stcnt={PHY[1:0],tileX[0],tileY[0],4'b0}; else stcnt=stcnt+memsz;
    `else 
    if (rst) stcnt={tileX[0],tileY[0],4'b0}; else stcnt=stcnt+memsz;
    `endif 
    for(regcnt=1;regcnt<(83);regcnt=regcnt+1) begin
         waddr0_reg[regcnt]<=waddr0_reg[regcnt-1];
         wren_in_reg[regcnt]<=wren_in_reg[regcnt-1];
         wrdata_reg[regcnt]<=wrdata_reg[regcnt-1];
         rdaddr0_reg[regcnt]<=rdaddr0_reg[regcnt-1];
         rdphydata0_reg[regcnt]<=rdphydata0_reg[regcnt-1];
         rden_in_reg[regcnt]<=rden_in_reg[regcnt-1];
         rdxdata_reg[regcnt]<=rdxdata_reg[regcnt-1];
    end
   // for(wport=0;wport<36;wport=wport+1) begin
          rdaddr0_reg[0]<=rdaddr0[36:4];
          rdphydata0_reg[0]<=rdphydata0;
          waddr0_reg[0]<=wraddr0[36:4];
          rdxdata_reg[0]<=rdaddr0[3:0];
          wren_in_reg[0]<=wren_in|rden_in&rdaddr0[37];
          rden_in_reg[0]<=rden_in;
          wrdata_reg[0]<=wrdata[8*66-1:0];
          if (rden_in_reg[access] && rddata[8*66]||wren_in_reg[access]) wrblockx(rdaddr0_reg[access][30:0],
             {rdxdata_reg[access],wren_in_reg[access]||rddata[8*66]&~rdnshare},tileX,tileY);
          pollwr<=0;
          pollrd<=0;
          polladdr<=0;// size,addr
          polldata<=0;
          if (wren_in_reg[access] && !rden_in_reg[access]) begin 
              wrblockwr(waddr0_reg[access][30:0],wrdata_reg[access][8*66-1:0],tileX,tileY);
              if (waddr0_reg[access][29:0]==64) begin
                  pollwr<=wrdata_reg[access][65];
                  pollrd<=wrdata_reg[access][63];
                  polladdr<=wrdata_reg[access][45:0];// size,addr
                  polldata<=wrdata_reg[access][66+:64];
              end
          end
          
          for(tlbptr=0;tlbptr<4;tlbptr=tlbptr+1) begin
              if (tlbdataw[66*tlbptr+:17]=={1'b1,rdaddr0_reg[44][32:17]} && rden_in_reg[44]) begin
                  rdaddr0_reg[45]<={tlbdataw[66*tlbptr+16+:16],rdaddr0_reg[44][16:0]};
              end
              if (tlbdata_reg[66*tlbptr+17+:16]=={rdaddr0_reg[45][32:17]} && rden_in_reg[45] && tlbdata_reg[66*tlbptr+16]) begin
                rdaddr0_xtra[tlbptr]<={tlbdata_reg[66*tlbptr+63],tlbdata_reg[66*tlbptr+:16],rdaddr0_reg[45][16:0]};
              end
              if (rdaddr0_xtra[tlbptr]==rdaddr0_rexx2) begin
                  rdaddr0_xtra_reg[0]<=rdaddr0_xtra[tlbptr];
                  rdaddr0_xtra_reg[tlbptr]<=rdaddr0_reg[46];
              end
              if (tlbdataw[66*tlbptr+:17]=={1'b1,waddr0_reg[44][32:17]} && wren_in_reg[44]) begin
                  waddr0_reg[45]<={tlbdataw[66*tlbptr+16+:16],waddr0_reg[44][16:0]};
              end
              if (tlbdataw_reg[66*tlbptr+17+:16]=={waddr0_reg[45][32:17]} && wren_in_reg[45] && tlbdataw_reg[66*tlbptr+16]) begin
                waddr0_xtra[tlbptr]<={tlbdataw_reg[66*tlbptr+63],tlbdataw_reg[66*tlbptr+:16],waddr0_reg[45][16:0]};
              end
              if (waddr0_xtra[tlbptr]==waddr0_rexx2) begin
                  waddr0_xtra_reg[0]<=waddr0_xtra[tlbptr];
                  waddr0_xtra_reg[tlbptr]<=waddr0_reg[46];
              end
              waddr0_rexx<=waddr0_reg[45];
              waddr0_rexx2<=waddr0_rexx;
              rdaddr0_rexx<=rdaddr0_reg[45];
              rdaddr0_rexx2<=rdaddr0_rexx;
              tlbdata_reg<=tlbdataw;
              tlbdataw_reg<=tlbdataw;
          end 
    //end
        
  end
  
endmodule
